Enforce type definitions to consistently use either `interface` or `type`.


TypeScript provides two common ways to define an object type: `interface` and `type`.

```ts
// type alias
type T1 = {
  a: string;
  b: number;
};

// interface keyword
interface T2 {
  a: string;
  b: number;
}
```

The two are generally very similar, and can often be used interchangeably.
Using the same type declaration style consistently helps with code readability.

## When Not To Use It

If you specifically want to use an interface or type literal for stylistic reasons, you can disable this rule.
