Require a specific member delimiter style for interfaces and type literals.


TypeScript allows three delimiters between members in interfaces and type aliases:

<!-- prettier-ignore -->
```ts
interface Foo {
    // Semicolons (default, preferred in TypeScript):
    name: string;

    // Commas (JSON-like):
    name: string,

    // Line breaks (none):
    name: string
}
```

For code readability, it's generally best to use the same style consistently in your codebase.

This rule enforces keeping to one configurable code style.
It can also standardize the presence (or absence) of a delimiter in the last member of a construct, as well as a separate delimiter syntax for single line declarations.

## Examples

Examples of code for this rule with the default config:

<!--tabs-->

### ❌ Incorrect

<!-- prettier-ignore -->
```ts
// missing semicolon delimiter
interface Foo {
    name: string
    greet(): string
}

// using incorrect delimiter
interface Bar {
    name: string,
    greet(): string,
}

// missing last member delimiter
interface Baz {
    name: string;
    greet(): string
}

// incorrect delimiter
type FooBar = { name: string, greet(): string }

// last member should not have delimiter
type FooBar = { name: string; greet(): string; }
```

### ✅ Correct

<!-- prettier-ignore -->
```ts
interface Foo {
    name: string;
    greet(): string;
}

interface Foo { name: string }

type Bar = {
    name: string;
    greet(): string;
}

type Bar = { name: string }

type FooBar = { name: string; greet(): string }
```

## When Not To Use It

If you don't care about enforcing a consistent member delimiter in interfaces and type literals, then you will not need this rule.
