Enforces consistent naming for boolean props.


Allows you to enforce a consistent naming pattern for props which expect a boolean value.

> **Note**: You can provide types in runtime types using [PropTypes] and/or
statically using [TypeScript] or [Flow]. This rule will validate your prop types
regardless of how you define them.

## Rule Details

Examples of **incorrect** code for this rule:

```jsx
var Hello = createReactClass({
  propTypes: {
    enabled: PropTypes.bool
  },
  render: function() { return <div />; };
});
```

```jsx
type Props = {
  enabled: boolean
}
const Hello = (props: Props) => <div />;
```

Examples of **correct** code for this rule:

```jsx
var Hello = createReactClass({
  propTypes: {
    isEnabled: PropTypes.bool
  },
  render: function() { return <div />; };
});
```

```jsx
type Props = {
  isEnabled: boolean
}
const Hello = (props: Props) => <div />
```
