An indented block comment was expected but a non-indented block comment was found instead.

### Anti-pattern

```python
def start(self):
    if True:
#       try:
#           self.master.start()
#       except MasterExit:
#           self.shutdown()
#       finally:
#           sys.exit()
        self.master.start()
```

### Best practice

```python
def start(self):
    if True:
        #  try:
        #      self.master.start()
        #  except MasterExit:
        #      self.shutdown()
        #  finally:
        #      sys.exit()
        self.master.start()
```
