If the namespace is assigned explicitly in the kubernetes manifest it should be for a custom namespace. Do not use the default namespace if you have more than one namespace.

# Details
The default namespace is created by Kubernetes itself and as the name indicates it is used as default if no other namespace is specified.
Using the default namespace only makes sense if the project is small enough that it is the only namespace being used.
In that case, it is best practice to never specify a namespace in Kubernetes manifest to have a clean and uniform style.
If the project requires multiple namespaces, the default namespace should not be used but only custom namespaces, because adding objects to the default namespace makes role-based access control more difficult.
Further, using the default namespace makes the system error-prone to human mistakes as developers may forget to explicitly set the namespace.
This would add the Kubernetes component to the default namespace which could lead to overwriting or disrupting other Kubernetes components in that namespace.
If the project is big enough that it requires multiple namespaces, then it is best practice to create separate namespaces for individual teams, projects or customers.
Using multiple namespaces does not add a performance penalty.
In contrary, it can even improve performance because requests and limits can be defined on a namespace-level.
Also, creating multiple namespaces is the first level of isolation providing separation of concern and decreasing the attack surface.

# Further Reading:
- Kubernetes API. Version 1.18.0. Kubernetes. Apr. 13, 2020.
- Derek Carr, Mike Danese, and Tim Hockin. Namespaces. July 17, 2020. url: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
- Brendan Burns et al. Kubernetes Best Practices. First Edition. Sebastopol: O’Reilly Media, Inc., 2019. isbn: 9781492056478.
- Rory Mccune and Liz Rice. CIS Kubernetes Benchmark. CIS Benchmarks, 2020.
- Sandeep Dinesh. Kubernetes best practices: Organizing with Namespaces. Apr. 27, 2018. url: https://cloud.google.com/blog/products/gcp/kubernetes-best-practices-organizing-with-namespaces
- Hasham Haider. Kubernetes Production Readiness and Best Practices Checklist. replex, 2019.
- Connor Gilbert. 9 Kubernetes Security Best Practices Everyone Must Follow. Jan. 14, 2019. url: https://www.cncf.io/blog/2019/01/14/9-kubernetes-security-best-practices-everyone-must-follow/