<h2>Why is this an issue?</h2>
<p>Delegate event handlers (i.e. delegates used as type of an event) should have a very specific signature:</p>
<ul>
  <li> Return type <code>void</code>. </li>
  <li> First argument of type <code>System.Object</code> and named 'sender'. </li>
  <li> Second argument of type <code>System.EventArgs</code> (or any derived type) and is named 'e'. </li>
</ul>
<p>This rule raises an issue whenever a <code>delegate</code> declaration doesn’t match that signature.</p>
<h3>Noncompliant code example</h3>
<pre>
public delegate void AlarmEventHandler(object s);

public class Foo
{
    public event AlarmEventHandler AlarmEvent; // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
public delegate void AlarmEventHandler(object sender, AlarmEventArgs e);

public class Foo
{
    public event AlarmEventHandler AlarmEvent; // Compliant
}
</pre>
<h2>Resources</h2>
<p><a href="https://msdn.microsoft.com/en-us/library/edzehd2t.aspx">Handling and Raising Events</a></p>

