﻿# SA1028

<table>
<tr>
  <td>TypeName</td>
  <td>SA1028CodeMustNotContainTrailingWhitespace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1028</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A line of code ends with a space, tab, or other whitespace characters before the end of line character(s).

## Rule description

A violation of this rule occurs when a line of code ends with any form of whitespace other than the end of line character(s). Extra whitespace can show up in editors with visible whitespace, or cause unnecessary code churn when developers format the document such that trailing whitespace is removed later. Some diff tools even highlight trailing whitespace to encourage developers to trim it.

### Detailed Behavior

The C# language contains several constructs which span multiple lines of code. The following table describes the behavior of this rule with respect to each of these constructs.

| Construct | Analysis Enabled |
| --- | --- |
| "Normal" code | ✔ |
| Line comments (starting with `// ...`) | ✔ |
| Inside block comments (`/* ... */`) | ✔ |
| Single-line documentation comments (`/// ...`) | ✔ |
| Multi-line documentation comments (`/** ... */`) | ✔ |
| Preprocessor directives (`#if`, `#pragma`, `#region`, etc.) | ✔ |
| Verbatim string literals (`@""`) | |
| Disabled code (text located within a `#if`, `#elif`, or `#else` block which is not active) | |

## How to fix violations

The fix an instance of this violation, delete all excess whitespace characters at the end of the line.

## How to suppress violations

```csharp
#pragma warning disable SA1028 // Code should not contain trailing whitespace
SomeMethodWithSpaceAfterTheSemicolon();    
#pragma warning restore SA1028 // Code should not contain trailing whitespace
```
