﻿## SA1115

<table>
<tr>
  <td>TypeName</td>
  <td>SA1115ParameterMustFollowComma</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1115</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A parameter within a C# method or indexer call or declaration does not begin on the same line as the previous parameter, or on the next line.

## Rule description

A violation of this rule occurs when there are one or more blank lines between a parameter and the previous parameter. For example:

```csharp
public string JoinName(
    string first, 

    string last)
{
}
```

The parameter should begin on the same line as the previous comma, or on the next line. For example:

```csharp
public string JoinName(string first, string last)
{
}

public string JoinName(
    string first, 
    string last)
{
}
```

## How to fix violations

To fix a violation of this rule, ensure that the parameter begins on the same line as the previous comma, or on the next line.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1115:ParameterMustFollowComma", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1115 // ParameterMustFollowComma
#pragma warning restore SA1115 // ParameterMustFollowComma
```
