﻿## SA1202

<table>
<tr>
  <td>TypeName</td>
  <td>SA1202ElementsMustBeOrderedByAccess</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1202</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

An element within a C# code file is out of order within regard to access level, in relation to other elements in the
code.

## Rule description

A violation of this rule occurs when the code elements within a file do not follow a standard ordering scheme based on
access level.

To comply with this rule, adjacent elements of the same type should be positioned in the following order by access level:

* public
* internal
* protected internal
* protected
* private protected
* private

:memo: Static constructors and explicitly implemented interface members are considered *public* for the purposes of this
rule.

Complying with a standard ordering scheme based on access level can increase the readability and maintainability of the
file and make it easier to identify the public interface that is being exposed from a class.

## How to fix violations

To fix an instance of this violation, order the elements in the file in the order described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1202:ElementsMustBeOrderedByAccess", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1202 // ElementsMustBeOrderedByAccess
#pragma warning restore SA1202 // ElementsMustBeOrderedByAccess
```
