﻿## SA1302

<table>
<tr>
  <td>TypeName</td>
  <td>SA1302InterfaceNamesMustBeginWithI</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1302</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

The name of a C# interface does not begin with the capital letter I.

## Rule description

A violation of this rule occurs when the name of an interface does not begin with the capital letter I. Interface names should always begin with I. For example, *ICustomer*.

If the field or variable name is intended to match the name of an item associated with Win32 or COM, and thus cannot begin with the letter I, place the field or variable within a special *NativeMethods* class. A NativeMethods class is any class which contains a name ending in NativeMethods, and is intended as a placeholder for Win32 or COM wrappers. StyleCop will ignore this violation if the item is placed within a NativeMethods class.

## How to fix violations

To fix a violation of this rule, add the capital letter I to the front of the interface name, or place the item within a NativeMethods class if appropriate.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1302:InterfaceNamesMustBeginWithI", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1302 // InterfaceNamesMustBeginWithI
#pragma warning restore SA1302 // InterfaceNamesMustBeginWithI
```
