﻿## SA1505

<table>
<tr>
  <td>TypeName</td>
  <td>SA1505OpeningBracesMustNotBeFollowedByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1505</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

An opening brace within a C# element, statement, or expression is followed by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when an opening brace is followed by a blank line. For example:

```csharp
public bool Enabled
{

    get 
    { 

        return this.enabled; 
    }
}
```

The code above would generate two instances of this violation, since there are two places where opening braces are followed by blank lines.

## How to fix violations

To fix a violation of this rule, remove the blank line following the opening brace.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1505:OpeningBracesMustNotBeFollowedByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1505 // OpeningBracesMustNotBeFollowedByBlankLine
#pragma warning restore SA1505 // OpeningBracesMustNotBeFollowedByBlankLine
```
