﻿## SA1603

<table>
<tr>
  <td>TypeName</td>
  <td>SA1603DocumentationMustContainValidXml</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1603</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

The Xml within a C# element's document header is badly formed.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the documentation Xml is badly formed and cannot be parsed. This can occur if the Xml contains invalid characters, or if an Xml node is missing a closing tag, for example.

## How to fix violations

To fix a violation of this rule, replace the badly formed Xml with valid Xml that can be parsed by a standard Xml parser.

The following example shows a class containing invalid Xml within its documentation header. The closing tag for the `<summary>` node is invalid.

```csharp
/// <summary>
/// An example of badly formed Xml.
/// </summa3ry>
public class Example
{
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1603:DocumentationMustContainValidXml", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1603 // DocumentationMustContainValidXml
#pragma warning restore SA1603 // DocumentationMustContainValidXml
```
