﻿## SA1649

<table>
<tr>
  <td>TypeName</td>
  <td>SA1649FileNameMustMatchTypeName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1649</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The file name of a C# code file does not match the first type declared in the file. For generics that are defined as
`Class1<T>` the name of the file needs to be `Class1{T}.cs` or ``Class1`1.cs`` depending on the `fileNamingConvention`
setting. See [Configuration.md](Configuration.md) for more information.

Partial classes are ignored.

## Rule description

A violation of this rule occurs when the file name of a C# file does not contain the name of the first type in the file.
For example, consider a C# source file named Class1.cs, with the following code:

```csharp
public class Class2
{
}
```

A violation of this rule would occur, since the file name is not contain the correct name of the first type in the file.
The file should be written as:

```csharp
public class Class1
{
}
```

## How to fix violations

To fix a violation of this rule, rename the file to  match the name of the first type from the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1649:FileNameMustMatchTypeName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1649 // SA1649FileNameMustMatchTypeName
#pragma warning restore SA1649 // SA1649FileNameMustMatchTypeName
```
