<h2>Why is this an issue?</h2>
<p>The purpose of checked exceptions is to ensure that errors will be dealt with, either by propagating them or by handling them, but some believe
that checked exceptions negatively impact the readability of source code, by spreading this error handling/propagation logic everywhere.</p>
<p>This rule verifies that no method throws a new checked exception.</p>
<h3>Noncompliant code example</h3>

```java
public void myMethod1() throws CheckedException {
  ...
  throw new CheckedException(message);   // Noncompliant
  ...
  throw new IllegalArgumentException(message); // Compliant; IllegalArgumentException is unchecked
}

public void myMethod2() throws CheckedException {  // Compliant; propagation allowed
  myMethod1();
}
```