<h2>Why is this an issue?</h2>
<p>When a class has all <code>final</code> fields, the compiler ensures that the object’s state remains constant. It also enforces a clear design
intent of immutability, making the class easier to reason about and use correctly.</p>
<p>Exceptions are meant to represent the application’s state at the point at which an error occurred. Making all fields in an <code>Exception</code>
class <code>final</code> ensures that these class fields do not change after initialization.</p>
<h3>Noncompliant code example</h3>

```java
public class MyException extends Exception {

  private int status;                        // Noncompliant

  public MyException(String message) {
    super(message);
  }

  public int getStatus() {
    return status;
  }

  public void setStatus(int status) {
    this.status = status;
  }

}
```
<h3>Compliant solution</h3>

```java
public class MyException extends Exception {

  private final int status;                  // Compliant

  public MyException(String message, int status) {
    super(message);
    this.status = status;
  }

  public int getStatus() {
    return status;
  }

}
```
<h2>Resources</h2>
<ul>
  <li> Effective Java 3rd Edition, Joshua Bloch - Exceptions - Item 76 : Strive for failure atomicity </li>
</ul>