<h2>Why is this an issue?</h2>
<p>The contract of the <code>Object.finalize()</code> method is clear: only the Garbage Collector is supposed to call this method.</p>
<p>Making this method public is misleading, because it implies that any caller can use it.</p>
<h3>Noncompliant code example</h3>

```java
public class MyClass {

  @Override
  public void finalize() {    // Noncompliant
    /* ... */
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/583">CWE-583 - finalize() Method Declared Public</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/4jZGBQ">CERT, MET12-J.</a> - Do not use finalizers </li>
</ul>