<h2>Why is this an issue?</h2>
<p>Sharing some naming conventions is a key point to make it possible for a team to efficiently collaborate. This rule allows to check that all
<code>abstract</code> class names match a provided regular expression. If a non-abstract class match the regular expression, an issue is raised to
suggest to either make it abstract or to rename it.</p>
<h3>Noncompliant code example</h3>
<p>With the default regular expression: <code>^Abstract[A-Z][a-zA-Z0-9]*$</code>:</p>

```java
abstract class MyClass { // Noncompliant
}

class AbstractLikeClass { // Noncompliant
}
```
<h3>Compliant solution</h3>

```java
abstract class AbstractClass {
}

class LikeClass {
}
```