<h2>Why is this an issue?</h2>
<p>A <code>for</code> loop is a type of loop construct that allows a block of code to be executed repeatedly for a fixed number of times. The
<code>for</code> loop is typically used when the number of iterations is known in advance and consists of three parts:</p>
<ul>
  <li> The initialization statement is executed once at the beginning of the loop. It is used to initialize the loop counter or any other variables
  that may be used in the loop. </li>
  <li> The loop condition is evaluated at the beginning of each iteration, and if it is <code>true</code>, the code inside the loop is executed. </li>
  <li> The update statement is executed at the end of each iteration and is used to update the loop counter or any other variables that may be used in
  the loop. </li>
</ul>

```java
for (initialization; termination; increment) { /*...*/ }
```
<p>All three statements are optional. However, when the initialization and update statements are not used, it can be unclear to the reader what the
loop counter is and how it is being updated. This can make the code harder to understand and maintain.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
for (;condition;) { /*...*/ } // Noncompliant; only the condition is specified
```
<p>When only the condition expression is defined in a <code>for</code> loop, a <code>while</code> loop should be used instead to increase readability.
A <code>while</code> loop consists of a single loop condition and allows a block of code to be executed repeatedly as long as the specified condition
is true.</p>
<h4>Compliant solution</h4>

```java
while (condition) { /*...*/ }
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/nutsandbolts/for.html">Java SE - The for Statement</a> </li>
</ul>