<h2>Why is this an issue?</h2>
<p>When the value of a private field is always assigned to in a class' methods before being read, then it is not being used to store class
information. Therefore, it should become a local variable in the relevant methods to prevent any misunderstanding.</p>
<h3>Noncompliant code example</h3>

```java
public class Foo {
  private int a;
  private int b;

  public void doSomething(int y) {
    a = y + 5;
    ...
    if(a == 0) {
      ...
    }
    ...
  }

  public void doSomethingElse(int y) {
    b = y + 3;
    ...
  }
}
```
<h3>Compliant solution</h3>

```java
public class Foo {

  public void doSomething(int y) {
    int a = y + 5;
    ...
    if(a == 0) {
      ...
    }
  }

  public void doSomethingElse(int y) {
    int b = y + 3;
    ...
  }
}
```
<h3>Exceptions</h3>
<p>This rule doesn’t raise any issue on annotated field.</p>