<h2>Why is this an issue?</h2>
<p>Strings are immutable objects, so concatenation doesn’t simply add the new String to the end of the existing string. Instead, in each loop
iteration, the first String is converted to an intermediate object type, the second string is appended, and then the intermediate object is converted
back to a String. Further, performance of these intermediate operations degrades as the String gets longer. Therefore, the use of StringBuilder is
preferred.</p>
<h3>Noncompliant code example</h3>

```java
String str = "";
for (int i = 0; i < arrayOfStrings.length ; ++i) {
  str = str + arrayOfStrings[i];
}
```
<h3>Compliant solution</h3>

```java
StringBuilder bld = new StringBuilder();
  for (int i = 0; i < arrayOfStrings.length; ++i) {
    bld.append(arrayOfStrings[i]);
  }
  String str = bld.toString();
```