<h2>Why is this an issue?</h2>
<p>There is no reason to re-assign a variable to itself. Either this statement is redundant and should be removed, or the re-assignment is a mistake
and some other value or variable was intended for the assignment instead.</p>
<h3>Noncompliant code example</h3>

```java
public void setName(String name) {
  name = name;
}
```
<h3>Compliant solution</h3>

```java
public void setName(String name) {
  this.name = name;
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/5dUxBQ">CERT, MSC12-C.</a> - Detect and remove code that has no effect or is never executed
  </li>
</ul>