<h2>Why is this an issue?</h2>
<p>Calling constructors for <code>String</code>, <code>BigInteger</code>, <code>BigDecimal</code> and the objects used to wrap primitives is less
efficient and less clear than relying on autoboxing or <code>valueOf</code>.</p>
<p>Consider simplifying when possible for more efficient and cleaner code.</p>
<h3>Noncompliant code example</h3>

```java
String empty = new String(); // Noncompliant; yields essentially "", so just use that.
String nonempty = new String("Hello world"); // Noncompliant
Double myDouble = new Double(1.1); // Noncompliant; use valueOf
Integer integer = new Integer(1); // Noncompliant
Boolean bool = new Boolean(true); // Noncompliant
BigInteger bigInteger1 = new BigInteger("3"); // Noncompliant
BigInteger bigInteger2 = new BigInteger("9223372036854775807"); // Noncompliant
BigInteger bigInteger3 = new BigInteger("111222333444555666777888999"); // Compliant, greater than Long.MAX_VALUE
BigDecimal bigDecimal = new BigDecimal("42.0"); // Compliant (see Exceptions section)
```
<h3>Compliant solution</h3>

```java
String empty = "";
String nonempty = "Hello world";
Double myDouble = 1.1;
Integer integer = 1;
Boolean bool = true;
BigInteger bigInteger1 = BigInteger.valueOf(3);
BigInteger bigInteger2 = BigInteger.valueOf(9223372036854775807L);
BigInteger bigInteger3 = new BigInteger("111222333444555666777888999");
BigDecimal bigDecimal = new BigDecimal("42.0");
```
<h3>Exceptions</h3>
<p><code>BigDecimal</code> constructor with a <code>double</code> argument is ignored as using <code>valueOf</code> instead might change the resulting
value. See <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S2111'>java:S2111</a>.</p>
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/data/autoboxing.html">Oracle - Learning the Java Language</a> - Autoboxing and Unboxing
  </li>
</ul>