<h2>Why is this an issue?</h2>
<p>The <code>Reader.read()</code> and the <code>BufferedReader.readLine()</code> are used for reading data from a data source. The return value of
these methods is the data read from the data source, or <code>null</code> when the end of the data source is reached. If the return value is ignored,
the data read from the source is thrown away and may indicate a bug.</p>
<p>This rule raises an issue when the return values of <code>Reader.read()</code> and <code>BufferedReader.readLine()</code> and their subclasses are
ignored or merely null-checked.</p>
<h3>Noncompliant code example</h3>

```java
public void doSomethingWithFile(String fileName) {
  try(BufferedReader buffReader = new BufferedReader(new FileReader(fileName))) {
    while (buffReader.readLine() != null) { // Noncompliant
      // ...
    }
  } catch (IOException e) {
    // ...
  }
}
```
<h3>Compliant solution</h3>

```java
public void doSomethingWithFile(String fileName) {
  try(BufferedReader buffReader = new BufferedReader(new FileReader(fileName))) {
    String line = null;
    while ((line = buffReader.readLine()) != null) {
      // ...
    }
  } catch (IOException e) {
    // ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/Reader.html#read()">Oracle SDK 20 - Reader.read()</a> </li>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/BufferedReader.html#readLine()">Oracle SDK 20 -
  BufferedReader.readLine()</a> </li>
</ul>