<h2>Why is this an issue?</h2>
<p>A <code>catch</code> clause that only rethrows the caught exception has the same effect as omitting the <code>catch</code> altogether and letting
it bubble up automatically.</p>

```java
public String readFile(File f) throws IOException {
  String content;
  try {
    content = readFromDisk(f);
  } catch (IOException e) {
    throw e;
  }
  return content;
}
```
<p>Such clauses should either be removed or populated with the appropriate logic.</p>

```java
public String readFile(File f) throws IOException {
  return readFromDisk(f);
}
```
<p>or</p>

```java
public String readFile(File f) throws IOException {
  String content;
  try {
    content = readFromDisk(f);
  } catch (IOException e) {
    logger.LogError(e);
    throw e;
  }
  return content;
}
```
<p>In the case of try-with-resources, the try should remain even without a catch clause, to keep the resource management</p>

```java
String readFirstLine(FileReader fileReader) throws IOException {
  try (BufferedReader br = new BufferedReader(fileReader)) {
     return br.readLine();
  } catch (IOException e) { // Noncompliant
  throw e;
}
```
<p>becomes</p>

```java
String readFirstLine(FileReader fileReader) throws IOException {
  try (BufferedReader br = new BufferedReader(fileReader)) {
     return br.readLine();
  }
}
```