<h2>Why is this an issue?</h2>
<p>A method with a <code>@RequestMapping</code> annotation part of a class annotated with <code>@Controller</code> (directly or indirectly through a
meta annotation - <code>@RestController</code> from Spring Boot is a good example) will be called to handle matching web requests. That will happen
even if the method is <code>private</code>, because Spring invokes such methods via reflection, without checking visibility.</p>
<p>So marking a sensitive method <code>private</code> may seem like a good way to control how such code is called. Unfortunately, not all Spring
frameworks ignore visibility in this way. For instance, if you’ve tried to control web access to your sensitive, <code>private</code>,
<code>@RequestMapping</code> method by marking it <code>@Secured</code> …​ it will still be called, whether or not the user is authorized to access
it. That’s because AOP proxies are not applied to private methods.</p>
<p>In addition to <code>@RequestMapping</code>, this rule also considers the annotations introduced in Spring Framework 4.3: <code>@GetMapping</code>,
<code>@PostMapping</code>, <code>@PutMapping</code>, <code>@DeleteMapping</code>, <code>@PatchMapping</code>.</p>
<h3>Noncompliant code example</h3>

```java
@RequestMapping("/greet", method = GET)
private String greet(String greetee) {  // Noncompliant
```
<h3>Compliant solution</h3>

```java
@RequestMapping("/greet", method = GET)
public String greet(String greetee) {
```
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
</ul>