<h2>Why is this an issue?</h2>
<p>Getters and setters provide a way to enforce encapsulation by providing <code>public</code> methods that give controlled access to
<code>private</code> fields. However, in classes with multiple fields, it is not unusual that copy and paste is used to quickly create the needed
getters and setters, which can result in the wrong field being accessed by a getter or setter.</p>
<p>This rule raises an issue in any of these cases:</p>
<ul>
  <li> A setter does not update the field with the corresponding name. </li>
  <li> A getter does not access the field with the corresponding name. </li>
</ul>
<h3>Noncompliant code example</h3>

```java
class A {
  private int x;
  private int y;

  public void setX(int val) { // Noncompliant: field 'x' is not updated
    this.y = val;
  }

  public int getY() { // Noncompliant: field 'y' is not used in the return value
    return this.x;
  }
}
```
<h3>Compliant solution</h3>

```java
class A {
  private int x;
  private int y;

  public void setX(int val) {
    this.x = val;
  }

  public int getY() {
    return this.y;
  }
}
```