<h2>Why is this an issue?</h2>
<p>Maps use hashes of the keys to select a bucket to store data in. Objects that hash to the same value will be added to the same bucket.</p>
<p>When the hashing function has a poor distribution, buckets can grow to very large sizes. This may negatively affect lookup performance, as, by
default, matching a key within a bucket has linear complexity.</p>
<p>In addition, as the default hashCode function can be selected at runtime, performance expectations cannot be maintained.</p>
<p>Implementing Comparable mitigates the performance issue for objects that hash to the same value.</p>
<h3>Noncompliant code example</h3>

```java
class MyKeyType {
    // ...
}

class Program {
    Map<MyKeyType, MyValueType> data = new HashMap<>(); // Noncompliant

    Map<MyKeyType, MyValueType> buildMap() { // Noncompliant
        //...
    }
}
```
<h3>Compliant solution</h3>

```java
class MyKeyType implements Comparable<MyKeyType> {
    // ...
}

class MyChildKeyType extends MyKeyType {
    // ...
}

class Program {
    Map<MyKeyType, MyValueType> data = new HashMap<>();
    Map<MyChildKeyType, MyValueType> data = new HashMap<>();

    Map<MyKeyType, MyValueType> buildMap() {
        //...
    }
}
```
<h2>Resources</h2>
<ul>
  <li> <a
  href="https://dzone.com/articles/java-8-hashmaps-keys-and-the-comparable-interface">https://dzone.com/articles/java-8-hashmaps-keys-and-the-comparable-interface</a> </li>
  <li> <a
  href="https://github.com/openjdk/jdk/blob/4927ee426aedbeea0f4119bac0a342c6d3576762/src/hotspot/share/runtime/synchronizer.cpp#L760-L798">https://github.com/openjdk/jdk/blob/4927ee426aedbeea0f4119bac0a342c6d3576762/src/hotspot/share/runtime/synchronizer.cpp#L760-L798</a> </li>
  <li> <a
  href="https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/lang/Comparable.html">https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/lang/Comparable.html</a> </li>
</ul>