<h2>Why is this an issue?</h2>
<p>A loop is a control structure that allows a block of code to be executed repeatedly until a certain condition is met. The basic idea behind a loop
is to automate repetitive tasks, such as iterating over a collection of data or performing a calculation multiple times with different inputs.</p>
<p>An infinite loop is a loop that runs indefinitely without ever terminating. In other words, the loop condition is always true, and the loop never
exits. This can happen when the loop condition is not defined or when the loop condition is never met.</p>
<p>Infinite loops can cause a program to hang or crash, as the program will continue to execute the loop indefinitely.</p>
<p>This rule will raise an issue on <code>for</code>, <code>while</code> and <code>do...while</code> loops where no clear exit condition has been
found.</p>
<p>There are some known limitations for this rule:</p>
<ul>
  <li> False positives: when an exception is raised by a function invoked within the loop. </li>
  <li> False negatives: when a loop condition is based on an element of an array or object. </li>
</ul>

```js
for (;;) {  // Noncompliant: end condition omitted
  // ...
}

let j = 0;
while (true) { // Noncompliant: constant end condition
  j++;
}

let k;
let b = true;
while (b) { // Noncompliant: constant end condition
  k++;
}
```
<p>Ensure the loop condition is defined or use a <code>break</code> statement.</p>

```js
for (let i = 0; i < 5; i++) {
  // ...
}

let j = 0;
while (true) {
  j++;
  if (j < 5) {
    break;
  }
}

let k;
let b = true;
while (b) {
  k++;
  b = k < 10;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Loops_and_iteration">Loops and iteration</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for"><code>for</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/while"><code>while</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/do...while"><code>do...while</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/break"><code>break</code></a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Infinite_loop">Infinite loop</a> </li>
</ul>