<p>This rule is deprecated; use javascript:S1523 instead.</p>
<h2>Why is this an issue?</h2>
<p>In addition to being obtuse from a syntax perspective, function constructors are also dangerous: their execution evaluates the constructor’s string
arguments similar to the way <code>eval</code> works, which could expose your program to random, unintended code which can be both slow and a security
risk.</p>
<p>In general it is better to avoid it altogether, particularly when used to parse JSON data. You should use ECMAScript 5’s built-in JSON functions or
a dedicated library.</p>
<h3>Noncompliant code example</h3>

```js
var obj =  new Function("return " + data)();  // Noncompliant
```
<h3>Compliant solution</h3>

```js
var obj = JSON.parse(data);
```
<h3>Exceptions</h3>
<p>Function calls where the argument is a string literal (e.g. <code>(Function('return this'))()</code>) are ignored.</p>
<h2>Resources</h2>
<ul>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A1_2017-Injection">Top 10 2017 Category A1 - Injection</a> </li>
</ul>