<h2>Why is this an issue?</h2>
<p>Originally JavaScript didn’t support <code>class</code>es, and class-like behavior had to be kludged using things like <code>prototype</code>
assignments for "class" functions. Fortunately, ECMAScript 2015 added classes, so any lingering <code>prototype</code> uses should be converted to
true <code>class</code>es. The new syntax is more expressive and clearer, especially to those with experience in other languages.</p>
<p>Specifically, with ES2015, you should simply declare a <code>class</code> and define its methods inside the class declaration.</p>
<h3>Noncompliant code example</h3>

```js
function MyNonClass(initializerArgs = []) {
  this._values = [...initializerArgs];
}

MyNonClass.prototype.doSomething = function () {  // Noncompliant
  // ...
}
```
<h3>Compliant solution</h3>

```js
class MyClass {
  constructor(initializerArgs = []) {
    this._values = [...initializerArgs];
  }

  doSomething() {
    //...
  }
}
```