<h2>Why is this an issue?</h2>
<p>Sometimes there is the need to cancel the execution of a coroutine after a given period of time. You can do this manually by combining the
<code>delay()</code> and <code>cancel()</code> functions. However, this technique is verbose and error-prone. An easier way to manage timeouts is
using the function <code>withTimeout()</code> or <code>withTimeoutOrNull()</code>.</p>
<p>The <code>withTimeout</code> function will throw a <code>TimeoutCancellationException</code> when the timeout is reached, while
<code>withTimeoutOrNull</code> will simply return <code>null</code> instead.</p>
<p>This rule raises an issue if timeout mechanisms are implemented manually instead of using appropriate built-in functions.</p>
<h3>Noncompliant code example</h3>

```kotlin
suspend fun main() {
    coroutineScope {
        val job = launch {
            delay(2000L)
            println("Finished")
        }
        delay(500L)
        job.cancel()
    }
}
```
<h3>Compliant solution</h3>

```kotlin
suspend fun main() {
    coroutineScope {
        withTimeoutOrNull(1000L){
            delay(2000L)
            println("Finished")
        }
    }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://kotlinlang.org/docs/cancellation-and-timeouts.html">Cancellation and timeouts</a> </li>
</ul>