<h2>Why is this an issue?</h2>
<p>An <code>preg_replace</code> call always performs an evaluation of the first argument as a regular expression, even if no regular expression
features were used. This has a significant performance cost and therefore should be used with care.</p>
<p>When <code>preg_replace</code> is used, the first argument should be a real regular expression. If it’s not the case, <code>str_replace</code> does
exactly the same thing as <code>preg_replace</code> without the performance drawback of the regex.</p>
<p>This rule raises an issue for each <code>preg_replace</code> used with a simple string as first argument which doesn’t contains special regex
character or pattern.</p>
<h3>Noncompliant code example</h3>

```php
$str = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
$changed = preg_replace("/Bob is/", "It's", $str); // Noncompliant
$changed = preg_replace("/\.\.\./", ";", $changed); // Noncompliant
```
<h3>Compliant solution</h3>

```php
$str = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
$changed = str_replace("Bob is", "It's", $str);
$changed = str_replace("...", ";", $changed);
```
<p>Or, with a regex:</p>

```php
$str = "Bob is a Bird... Bob is a Plane... Bob is Superman!";
$changed = preg_replace("/\w*\sis/", "It's", $str);
$changed = preg_replace("/\.{3}/", ";", $changed);
```