<p>There is no good excuse for an empty class. If it’s being used simply as a common extension point, it should be replaced with an
<code>interface</code>. If it was stubbed in as a placeholder for future development it should be fleshed-out. In any other case, it should be
eliminated.</p>
<p>Additionally, one shouldn’t use a class to define exclusively static methods. Instead one can use a module, or better, export each function
separately.</p>
<h2>Why is this an issue?</h2>
<p>Using an empty class serves no purpose and can hinder the readability of the code.</p>

```ts
class Foo {
  static bar() {
    // ...
  }
}
```
<h2>How to fix it</h2>
<p>You can export the functions that you wish to make available.</p>

```ts
export function bar()  {
  // ...
}
```
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
class Foo { // Noncompliant
  static bar() {
    // ...
  }
}
```
<h4>Compliant solution</h4>

```ts
export function bar() {
  // ...
}
```
<h4>Noncompliant code example</h4>

```ts
class DoAndLog { // Noncompliant
  constructor () {
    console.log('I\'m done!');
  }
}
```
<h4>Compliant solution</h4>

```ts
function doAndLog() {
  console.log('I\'m done!');
}
```