<h2>Why is this an issue?</h2>
<p>In a <code>for</code> loop, the update clause is responsible for modifying the loop counter variable in the appropriate direction to control the
loop’s iteration. It determines how the loop counter variable changes with each iteration of the loop. The loop counter should move in the right
direction to prevent infinite loops or unexpected behavior.</p>
<p>This rule raises an issue when the loop counter is updated in the wrong direction with respect to the loop termination condition.</p>

```ts
for (let i = 0; i < strings.length; i--) { // Noncompliant: The counter 'i' is decremented, making the loop infinite
  //...
}
```
<p>To ensure the <code>for</code> loop behaves as expected, you should specify the correct update clause that moves the loop counter in the right
direction based on the loop’s logic and desired outcome.</p>

```ts
for (let i = 0; i < strings.length; i++) {
  //...
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for"><code>for</code></a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Infinite_loop">Infinite loop</a> </li>
</ul>