<h2>Why is this an issue?</h2>
<p>A <code>catch</code> clause that only rethrows the caught exception has the same effect as omitting the <code>catch</code> altogether and letting
it bubble up automatically.</p>

```ts
try {
  doSomething();
} catch (ex) {  // Noncompliant
  throw ex;
}
```
<p>Such clauses should either be removed or populated with the appropriate logic.</p>

```ts
doSomething();
```
<p>or</p>

```ts
try {
  doSomething();
} catch (ex) {
  console.err(ex);
  throw ex;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/try...catch"><code>try...catch</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/throw"><code>throw</code></a> </li>
</ul>