<h2>Why is this an issue?</h2>
<p>Placing an <code>if</code> statement on the same line as the closing <code>}</code> from a preceding <code>if</code>, <code>else</code>, or
<code>else if</code> block can lead to confusion and potential errors. It may indicate a missing <code>else</code> statement or create ambiguity for
maintainers who might fail to understand that the two statements are unconnected.</p>
<p>The following code snippet is confusing:</p>

```ts
if (condition1) {
  // ...
} if (condition2) {  // Noncompliant
  //...
}
```
<p>Either the two conditions are unrelated and they should be visually separated:</p>

```ts
if (condition1) {
  // ...
}

if (condition2) {
  //...
}
```
<p>Or they were supposed to be exclusive and you should use <code>else if</code> instead:</p>

```ts
if (condition1) {
  // ...
} else if (condition2) {
  //...
}
```