<h2>Why is this an issue?</h2>
<p>When using testing frameworks like Mocha and Jest, appending <code>.only()</code> to the test function allows running a single test case for a
file. Using <code>.only()</code> means no other test from this file is executed. This is useful when debugging a specific use case.</p>

```ts
describe("MyClass", function () {
    it.only("should run correctly", function () { // Noncompliant
        /*...*/
    });
});
```
<p>However, it should not be used in production or development, as it is likely a leftover from debugging and serves no purpose in those contexts. It
is strongly recommended not to include <code>.only()</code> usages in version control.</p>

```ts
describe("MyClass", function () {
    it("should run correctly", function () {
        /*...*/
    });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Mocha Documentation - <a href="https://mochajs.org/#exclusive-tests">Exclusive tests</a> </li>
  <li> Jest Documentation - <a href="https://jestjs.io/docs/next/api#testonlyname-fn-timeout"><code>test.only()</code></a> </li>
  <li> Jest Documentation - <a href="https://jestjs.io/docs/next/api#describeonlyname-fn"><code>describe.only()</code></a> </li>
</ul>