<h2>Why is this an issue?</h2>
<p>Octal escape sequences in string literals have been deprecated since ECMAScript 5 and should not be used in modern JavaScript code.</p>
<p>Many developers may not have experience with this format and may confuse it with the decimal notation.</p>

```ts
let message = "Copyright \251"; // Noncompliant
```
<p>The better way to insert special characters is to use Unicode or hexadecimal escape sequences.</p>

```ts
let message1 = "Copyright \u00A9";  // unicode
let message2 = "Copyright \xA9";    // hexadecimal
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Grammar_and_types#string_literals">String literals</a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Deprecated_octal">SyntaxError: Octal escape
  sequences are deprecated</a> </li>
</ul>