"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RULE_NAME = void 0;
const utils_1 = require("@angular-eslint/utils");
const utils_2 = require("@typescript-eslint/utils");
const create_eslint_rule_1 = require("../utils/create-eslint-rule");
exports.RULE_NAME = 'no-host-metadata-property';
const DEFAULT_OPTIONS = { allowStatic: false };
const METADATA_PROPERTY_NAME = 'host';
const STYLE_GUIDE_LINK = 'https://angular.io/styleguide#style-06-03';
exports.default = (0, create_eslint_rule_1.createESLintRule)({
    name: exports.RULE_NAME,
    meta: {
        type: 'suggestion',
        docs: {
            description: `Disallows usage of the \`${METADATA_PROPERTY_NAME}\` metadata property. See more at ${STYLE_GUIDE_LINK}`,
            recommended: 'recommended',
        },
        schema: [
            {
                type: 'object',
                properties: {
                    allowStatic: {
                        type: 'boolean',
                        default: DEFAULT_OPTIONS.allowStatic,
                    },
                },
                additionalProperties: false,
            },
        ],
        messages: {
            noHostMetadataProperty: `Use @${utils_1.ASTUtils.AngularInnerClassDecorators.HostBinding} or @${utils_1.ASTUtils.AngularInnerClassDecorators.HostListener} rather than the \`${METADATA_PROPERTY_NAME}\` metadata property (${STYLE_GUIDE_LINK})`,
        },
    },
    defaultOptions: [DEFAULT_OPTIONS],
    create(context, [{ allowStatic }]) {
        return {
            [`${utils_1.Selectors.COMPONENT_OR_DIRECTIVE_CLASS_DECORATOR} Property[key.name="${METADATA_PROPERTY_NAME}"]`](node) {
                const properties = allowStatic && utils_1.ASTUtils.isObjectExpression(node.value)
                    ? node.value.properties.filter(isDynamic)
                    : [node];
                properties.forEach((property) => {
                    context.report({
                        node: property,
                        messageId: 'noHostMetadataProperty',
                    });
                });
            },
        };
    },
});
function startsWithLetter({ [0]: firstLetter }) {
    return firstLetter.toLowerCase() !== firstLetter.toUpperCase();
}
function isEmptyStringValue(property) {
    return (utils_1.ASTUtils.isStringLiteral(property.value) && property.value.value === '');
}
function isStatic(property) {
    return (!property.computed &&
        (utils_2.ASTUtils.isIdentifier(property.key) ||
            (utils_1.ASTUtils.isStringLiteral(property.key) &&
                startsWithLetter(property.key.value))));
}
function isDynamic(property) {
    return (utils_1.ASTUtils.isProperty(property) &&
        !isStatic(property) &&
        !isEmptyStringValue(property));
}
