During a `SUBMIT` it is possible to act as another `USER`.
This is likely not a security problem, but it can make the code difficult to understand.

# What Does This Check Look For?

This check reports findings for usages of the `USER` keyword within a `SUBMIT` statement.

# Why is This a Problem?

This is likely not a security problem since the ABAP runtime ensures that the current logon user has the permission to execute a background task as the given user.
However, usage of this function should still be reviewed and limited to the necessary amount to reduce the surface for misuse.

# How Can I Resolve This?

Avoid usage of `USER` in `SUBMIT` statements.

# Where Can I Learn More?

- [ABAP Keyword Documentation: SUBMIT](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abapsubmit_via_job.htm)
- [ABAP Security Notes: User-Dependent Program Flow](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abenauthorization_object_glosry.htm)
