This check detects arrays used as method arguments.
It reports an extra finding if `sizeof` is used on an array argument.

# Why is This a Problem?
Arrays as method arguments are misleading as they are internally converted to a pointer.
This leads `sizeof` to return the size of the pointer instead of the size of the array.
This can further lead to falsely assumed guarantees if the parameter specifies a size of the array.

# How Can I Resolve This?
Directly use a pointer as a formal parameter and add a parameter for the array size if necessary.

## Example (Before)

```cpp
bool isAllUpperCase(char a[30]) {
  for (int i = 0; i < 30; i++) {
    if (islower(a[i]) {
      return false;
    }
  }
  return true;
}
```

## Example (After)

```cpp
bool isAllUpperCase(char* a, int size) {
  for (int i = 0; i < size; i++) {
    if (islower(a[i]) {
      return false;
    }
  }
  return true;
}
```