Inverting the condition in an assert statement should be avoided.
Use the inverse assertion `assertTrue` or `assertFalse` instead.

# What Does This Check Look For?

This looks for a negated condition in `assertTrue` and `assertFalse`.

# Why is This a Problem?

Inverting the condition in an assert statement is less clear than using the inverse assertion method.

# How Can I Resolve This?

Use `assertTrue(expression)` instead of `assertFalse(!expression)` and `assertFalse(expression)` instead of `assertTrue(!expression)`.

# Examples

## Non-Compliant

```java
void test() {
	assertTrue(!list.contains(1));
}
```

## Compliant

```java
void test() {
	assertFalse(list.contains(1));
}
```
