Variables that are used in the code but never declared can lead to runtime errors, unexpected behavior, or reliance on unintended global variables.
Instead, all variables should be explicitly declared to ensure clarity, correctness, and maintainability.

# What Does This Check Look For?
This check reports a finding when a variable is used in the code without being explicitly declared.
It helps catch potential typos, missing declarations, or cases where MATLAB built-ins are unintentionally overwritten.
# Why is This a Problem?
Using undeclared variables can lead to unintended variable creation in MATLAB’s workspace, potentially introducing subtle bugs.
# How Can I Resolve This?
Ensure that all variables are explicitly declared before use. If the name is a MATLAB built-in function or constant, consider adding it to the ignored identifiers list.
# Examples
## Non-Compliant

```matlab
function y = computeValue(x)  
    y = x * factor; % Non-compliant: 'factor' is used but never declared  
end  
```
## Compliant

```matlab
function y = computeValue(x)  
    factor = 10;     % Compliant: 'factor' is properly declared  
    y = x * factor;  
end  
```

# Where Can I Learn More?
- [Clean Code: A Handbook of Agile Software Craftsmanship by Robert C. Martin](https://www.goodreads.com/book/show/3735293-clean-code)
- [Code Complete: A Practical Handbook of Software Construction, Second Edition by Steve McConnell](https://www.goodreads.com/book/show/4845.Code_Complete)
