This check detects String literals with python expressions inside curly braces that are not prefixed with `f`.
It checks whether the identifiers used inside the expressions are available within the scope of the String literal.

*Limitations:*
Will not flag pure mathematical expressions without identifiers, e.g. `"Result = {1 + 2}"`. 
Also will not flag any indirect variable or method calls, with the exception of `self`-calls.
Example:
```python
"My name: {self.name}"          # Finding
"Other name: {person.name}"     # No Finding
```

# Why is This a Problem?

This might result in an unwanted value of the String.
Probably you wanted to use an [f-String](https://realpython.com/python-f-strings/#f-strings-a-new-and-improved-way-to-format-strings-in-python) for formatting this String instead.

## Exceptions

Sometimes you really want the String to have this form.

*Example:*
```python
print('Some example json data: { "name": "Karl" }')
# Output: Some example json data: { "name": "Karl" }.
```

# How Can I Resolve This?

Insert the `f`-prefix just before the string literal.


## Example (Before)

```python
foo = 123
print("Value of foo: {foo}")
# Output: Value of foo: {foo}
```

## Example (After)

```python
foo = 123
print(f"Value of foo: {foo}")
# Output: Value of foo: 123
```

# Where Can I Learn More?

## References

- [Python docs: Formatted String Literals](https://docs.python.org/3/tutorial/inputoutput.html#formatted-string-literals)
- [String formatting Guide: Python 3's f-Strings: An Improved String Formatting Syntax (Guide)](https://realpython.com/python-f-strings/#f-strings-a-new-and-improved-way-to-format-strings-in-python)
