This check detects the use of bitwise logical operators (`&`, `|`and `^`) in conditional statements such as `if`, `[do] while` and `?:`.


# Why Is This A Problem ?
 Although being written on purpose in some rare cases, bitwise operations are considered to be too “smart”. Smart code is not easy to understand.
 
# How Can I Resolve This ?
If the bit operator is only used to evaluate `bool` values it can be replaced with their matching logical operator,
`&&`, `||` and `!=` respectively, since they work identical on `bool`values. This can even lead to performance improvements since [short-circuiting](https://www.geeksforgeeks.org/short-circuit-evaluation-in-programming/)
can be applied.

If you really want to use these operators to perform bit operations in your program try to make the operation easier to understand by precalculating some expressions that would otherwise clutter the condition term.
Also consider explaining what this operation does and why it archives the wanted behaviour in a comment.

## Example (Before)

```Objective-C
bool validateA() { //some code }
bool validateB() { //some code }

if (validateA() & validateB())  {
    //some code
}
```

## Example (After)

```Objective-C
bool validateA() { //some code }
bool validateB() { //some code }

if (validateA() && validateB())  {
    //some code
}
```
