Redundant parentheses make code unnecessarily verbose and are often less idiomatic.
They can safely be removed.

# What Does This Check Look For?

This check reports findings for redundant parentheses, i.e., parentheses that can safely be removed without altering the meaning of the code.
Parentheses around multi-line expressions, however, are not reported as they can improve readability.

# Why is This a Problem?

Using redundant parentheses makes the code unnecessarily verbose, increases the visual noise and can lead to confusion, especially if they are used inconsistently.
In addition, the code looks less idiomatic, as redundant parenthesis are commonly omitted for the aforementioned reasons.

# How Can I Resolve This?

To resolve this issue, simply remove the redundant parentheses.
In most cases, parentheses are only necessary to clarify the order of operations or when overriding operator precedence.
If the parentheses serve no purpose and do not improve readability, they should be removed.

# Examples

## Non-Compliant

```python
if (x > 5):                 # non-compliant
    do_something()

while ((x > 5)):            # non-compliant
    do_something()

clone = (type(obj)(obj))    # non-compliant
```

## Compliant

```python
if x > 5:                   # compliant
    do_something()

while x > 5:                # compliant
    do_something()

clone = type(obj)(obj)      # compliant

if (x > 5 and               # compliant
    y > 10):                # (exception for multi-line expressions)
    do_something()
```
