To ease comprehensibility, the default label of a switch statement should be at a consistent location, the end of the switch statement (or the beginning if configured so).
Consider moving the default label to the end of the switch statement (or the beginning if configured so).

# What Does This Check Look For?

This check searches for default labels in switch statements that are not at the end of the switch statement (or at the beginning if configured so).

# Why is This a Problem?

Not having the default label at a consistent location leads to worse comprehensibility.
Developers then need to search the whole switch statement to find the default label and may miss it.

# How Can I Resolve This?

Move the default label to the configured location in the switch statement (by default the end of the switch statement).

# Examples

## Non-Compliant

```java
switch(expression) {
    case 1:
        // handle case 1
        break;
    default: // non-compliant: default label in the middle of switch statement
        // ...
        break;
    case 2:
        // handle case 2
        break;
}
```

## Compliant

```java
switch(expression) {
    case 1:
        // handle case 1
        break;
    case 2:
        // handle case 2
        break;
    default: // compliant: default label at end of switch statement
        // ...
        break;
}
```
