<h2>Why is this an issue?</h2>
<p>AssertJ assertions methods targeting the same object can be chained instead of using multiple <code>assertThat</code>. It avoids duplication and
increases the clarity of the code.</p>
<p>This rule raises an issue when multiples <code>assertThat</code> target the same tested value.</p>
<h3>Noncompliant code example</h3>

```java
assertThat(someList).hasSize(3);
assertThat(someList).contains("something");
```
<h3>Compliant solution</h3>

```java
assertThat(someList)
  .hasSize(3)
  .contains("something");
```