<p>"Monster Class" is a class that implements too many functionalities that are not well organized, or cohesive. Monster Classes are not created
intentionally, but rather they often arise over time as a result of poor software design or a lack of attention to good programming practices such as
modularization and encapsulation. As a software evolves and new requirements are added, it can be tempting to add new functionality to existing
classes rather than creating new classes to handle the new functionality. This leads to classes becoming bloated and difficult to understand and
maintain, ultimately resulting in a Monster Class.</p>
<p>Here are the characteristics of a Monster Class:</p>
<ul>
  <li> High number of instance variables and methods </li>
  <li> Variables and methods that are not related to each other (low cohesion and high coupling) </li>
  <li> Too many responsibilities, violating the Single Responsibility Principle (aka SRP) </li>
  <li> Difficult to test, leading to poor test coverage and a higher risk of defects </li>
</ul>
<h2>Why is this an issue?</h2>
<p>Monster Classes become monolithic entities, with numerous responsibilities and functionalities packed into a single class. This is problematic
because it violates the Single Responsibility Principle, which states that a class should have only one reason to change.</p>
<p>When a class has too many responsibilities and functionalities, it becomes difficult to maintain. Changes to one part of the class can
unintentionally affect other parts, leading to bugs. Additionally, it can be difficult to test the class, as there may be many different interactions
between different parts of the class that need to be considered.</p>
<h2>How to fix it</h2>
<p>There is no magical recipe. Monster Classes should be refactored and broken into smaller, more focused classes, each one with a single
responsibility. When a class has only one responsibility, it is easier to reason about its behavior and to make changes to it without affecting other
parts of the code.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>With a threshold of 5:</p>

```java
class Foo { // class Foo depends on too many classes: T1, T2, T3, T4, T5, T6 and T7
  T1 t1;
  T2 t2;
  T3 t3;

  public T4 compute(T5 a, T6 b) {
    T7 result = a.getResult(b);
    return (T4) result;
  }
}
```
<h4>Compliant solution</h4>

```java
public class Bar {
    T8 a8;
    T9 a9;
}
```
<h2>Resources</h2>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://blog.cleancoder.com/uncle-bob/2014/05/08/SingleReponsibilityPrinciple.html">Single Responsibility Principle (aka SRP)</a>
  </li>
  <li> <a href="https://en.wikipedia.org/wiki/SOLID">SOLID</a> </li>
</ul>