/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class LanguageDetection {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Map<Language, String[]> extensionsByLanguage = new LinkedHashMap<Language, String[]>();

    public LanguageDetection(Configuration config) {
        for (Language language : Language.values()) {
            String[] extensions = config.get(language.getFileSuffixesPropKey()).isPresent() ? config.getStringArray(language.getFileSuffixesPropKey()) : language.getDefaultFileSuffixes();
            for (int i = 0; i < extensions.length; ++i) {
                String suffix = extensions[i];
                extensions[i] = LanguageDetection.sanitizeExtension(suffix);
            }
            this.extensionsByLanguage.put(language, extensions);
        }
    }

    @CheckForNull
    public Language language(InputFile inputFile) {
        Language detectedLanguage = null;
        for (Map.Entry<Language, String[]> languagePatterns : this.extensionsByLanguage.entrySet()) {
            if (!LanguageDetection.isCandidateForLanguage(inputFile, languagePatterns.getValue())) continue;
            if (detectedLanguage == null) {
                detectedLanguage = languagePatterns.getKey();
                continue;
            }
            throw MessageException.of(MessageFormat.format("Language of file \"{0}\" can not be decided as the file extension matches both {1} and {2}", inputFile.uri(), this.getDetails(detectedLanguage), this.getDetails(languagePatterns.getKey())));
        }
        if (detectedLanguage != null) {
            LOG.debug("Language of file \"{}\" is detected to be \"{}\"", (Object)inputFile.uri(), (Object)detectedLanguage);
            return detectedLanguage;
        }
        return null;
    }

    private static boolean isCandidateForLanguage(InputFile inputFile, String[] extensions) {
        for (String extension : extensions) {
            if (!inputFile.filename().toLowerCase(Locale.ENGLISH).endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    private String getDetails(Language detectedLanguage) {
        return detectedLanguage + ": " + Arrays.stream(this.extensionsByLanguage.get((Object)detectedLanguage)).collect(Collectors.joining(","));
    }

    public static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase(StringUtils.removeStart(suffix, "."));
    }
}

